<?php
/*
                         ''~``
                        ( o o )
+------------------.oooO--(_)--Oooo.------------------+
|                    Unreal Portal                    |
|                    .oooO                            |
|                    (   )   Oooo.                    |
+---------------------\ (----(   )--------------------+
                       \_)    ) /
                             (_/


           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
           |The Logo Looks Best in Courier New|
           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

                       ---====---
                      Unreal Portal
                       By Cricket
*/

$TABLE[] = "CREATE TABLE up_settings (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(255) NOT NULL default '',
  `value` longtext NOT NULL,
  PRIMARY KEY (id)
) TYPE=MyISAM AUTO_INCREMENT=1 ;";

$TABLE[] = "CREATE TABLE unrealportal (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(255) NOT NULL default '',
  `title` varchar(255) NOT NULL default '',
  `align` varchar(255) NOT NULL default '',
  `show` int(11) NOT NULL default '1',
  `order2` int(11) NOT NULL default '0',
  `custblock_id` int(11) NOT NULL default '0',
  PRIMARY KEY (id)
) TYPE=MyISAM AUTO_INCREMENT=1 ;";

$TABLE[] = "CREATE TABLE up_custblocks (
  `id` int(11) NOT NULL auto_increment,
  `title` varchar(255) NOT NULL default '',
  `html` text NOT NULL,
  PRIMARY KEY (id)
) TYPE=MyISAM AUTO_INCREMENT=1 ;";

$TABLE[] = "CREATE TABLE up_custcontent (
  `id` int(11) NOT NULL auto_increment,
  `title` varchar(255) NOT NULL default '',
  `html` text NOT NULL,
  PRIMARY KEY (id)
) TYPE=MyISAM AUTO_INCREMENT=1 ;";

//START: Upgrade from Unreal Portal 2.3
if ( ! $this->DB->checkForField( 'id', "up_settings" ) )
{
    $this->DB->query("alter table {$this->DB->obj['sql_tbl_prefix']}up_settings ADD id int not null auto_increment primary key first"); 
}

if ( ! $this->DB->checkForField( 'custblock_id', "unrealportal" ) )
{
    $this->DB->query("alter table {$this->DB->obj['sql_tbl_prefix']}unrealportal ADD custblock_id int not null default 0");
}

if ( ! $this->DB->checkForField( 'id', "up_custblocks" ) )
{
    $this->DB->query("alter table {$this->DB->obj['sql_tbl_prefix']}up_custblocks ADD id int not null auto_increment primary key first"); 
}

if ( ! $this->DB->checkForField( 'id', "up_custcontent" ) )
{
    $this->DB->query("alter table {$this->DB->obj['sql_tbl_prefix']}up_custcontent ADD id int not null auto_increment primary key first"); 
}

if ( $this->DB->checkForField( 'name', "up_custblocks" ) )
{
    $this->DB->build( array( 
        'select'    => '*',
        'from'      => 'up_custblocks'
    ));
    $query = $this->DB->execute();

    while( $fetch = $this->DB->fetch($query) )
    {
        $this->DB->update( 'unrealportal', array( 'custblock_id' => $fetch['id'] ), "name='{$fetch['name']}'" );
    }
    
    $this->DB->dropField("up_custblocks", "name");
}

if ( $this->DB->checkForField( 'name', "up_custcontent" ) )
{
    $this->DB->dropField("up_custcontent", "name");
}
//END: Upgrade from Unreal Portal 2.3

?>